<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_admin'])) {
    header("Location: login.php");
    exit;
}

// daftar reservasi (mengolah data reservasi)
$sql_reservasi = "SELECT r.*, p.nama 
                  FROM tb_daftar_reservasi r 
                  JOIN tb_pelanggan p ON r.id_pelanggan = p.id_pelanggan
                  ORDER BY r.tanggal_reservasi DESC";
$result_reservasi = mysqli_query($conn, $sql_reservasi);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .dashboard-container {
            background-color: rgba(245, 230, 204, 0.9);
            padding: 20px;
            border-radius: 10px;
            max-width: 1000px;
            margin: 30px auto;
        }
        .btn-action {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
        table thead {
            background-color: #4A3728;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <h2>Dashboard Admin Kafe Omah Kopi</h2>
        <p>Selamat datang, <?php echo htmlspecialchars($_SESSION['username']); ?></p>

        <!-- MENU UTAMA ADMIN (sesuai flowchart: mengolah data reservasi & menu) -->
        <div class="mb-3">
            <a href="#reservasi" class="btn btn-action btn-sm">Kelola Reservasi</a>
            <a href="menu_admin.php" class="btn btn-action btn-sm">Kelola Data Menu</a>
            <a href="pesanan_admin.php" class="btn btn-action btn-sm">Lihat Pesanan</a>
            <a href="laporan_pesanan.php" class="btn btn-action btn-sm">Laporan Pesanan</a>
            <a href="register_admin.php" class="btn btn-action btn-sm">Tambah Admin/Staff</a>
            <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
        </div>

        <hr>

        <!-- DAFTAR RESERVASI (halaman reservasi + konfirmasi reservasi) -->
        <h4 id="reservasi">Daftar Reservasi</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nama Pelanggan</th>
                    <th>Tanggal</th>
                    <th>Meja</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($result_reservasi)) { ?>
                    <tr>
                        <td><?php echo $row['id_reservasi']; ?></td>
                        <td><?php echo $row['nama']; ?></td>
                        <td><?php echo $row['tanggal_reservasi']; ?></td>
                        <td><?php echo $row['nomor_meja']; ?></td>
                        <td><?php echo $row['status']; ?></td>
                        <td>
                            <?php if ($row['status'] != 'confirmed'): ?>
                                <a href="confirm_reservation.php?id=<?php echo $row['id_reservasi']; ?>" class="btn btn-sm btn-action">
                                    Konfirmasi Reservasi
                                </a>
                            <?php else: ?>
                                <span class="badge bg-success">Sudah dikonfirmasi</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>

    </div>
</body>
</html>
