<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Omah Kopi Jember</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat; /* Tekstur kayu sebagai latar */
            color: #3C2F2F; /* Teks cokelat tua */
            font-family: 'Georgia', serif;
        }
        .navbar {
            background-color: #4A3728; /* Warna kayu gelap */
        }
        .navbar-brand, .nav-link {
            color: #F5E6CC !important; /* Teks krem */
        }
        .hero {
            background: url('joglo_cafe.jpg') no-repeat center center;
            background-size: cover;
            height: 500px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: #FFF8E7; /* Teks krem muda */
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.7);
        }
        .hero h1 {
            font-size: 3.5rem;
            font-family: 'Cinzel', serif; /* Font elegan bergaya tradisional */
        }
        .btn-reserve {
            background-color: #8B5E3C; /* Cokelat hangat */
            border: none;
            padding: 10px 20px;
            font-size: 1.2rem;
            color: #FFF8E7;
        }
        .btn-reserve:hover {
            background-color: #A67B5B; /* Cokelat lebih terang saat hover */
        }
        .content {
            background-color: rgba(245, 230, 204, 0.9); /* Krem semi-transparan */
            padding: 20px;
            border-radius: 10px;
            margin: 20px auto;
            max-width: 800px;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="#">Omah Kopi</a>
            <div class="collapse navbar-collapse">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="login.php">Login</a></li>
                    <li class="nav-item"><a class="nav-link" href="register.php">Daftar</a></li>
                    <li class="nav-item"><a class="nav-link" href="reservation.php">reservation</a></li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="hero">
        <div>
            <h1>Selamat Datang di Omah Kopi Jember</h1>
            <p>Nikmati kehangatan tradisi Jawa dengan kopi otentik dan suasana nyaman.</p>
            <a href="reservation.php" class="btn btn-reserve">Buat Reservasi</a>
        </div>
    </div>
    <div class="content">
        <h2>Tentang Omah Kopi</h2>
        <p>Terletak di Jember, Omah Kopi menawarkan perpaduan unik antara arsitektur Joglo Jawa dan kenyamanan modern. Nikmati kopi lokal dan hidangan rumahan dalam suasana kayu yang tenang.</p>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>