<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_admin'])) {
    header("Location: login.php");
    exit;
}

$hasil = null;
$title = "";

// --- FILTER HARIAN ---
if (isset($_POST['filter']) && $_POST['filter'] == "harian") {
    $tgl = $_POST['tanggal'];
    $hasil = mysqli_query($conn, "
        SELECT p.*, pl.nama 
        FROM tb_pesanan p
        JOIN tb_pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
        WHERE DATE(p.tanggal) = '$tgl'
        ORDER BY p.id_pesanan DESC
    ");
    $title = "Laporan Harian: $tgl";
}

// --- FILTER BULAN INI ---
if (isset($_POST['filter']) && $_POST['filter'] == "bulan") {
    $hasil = mysqli_query($conn, "
        SELECT p.*, pl.nama 
        FROM tb_pesanan p
        JOIN tb_pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
        WHERE MONTH(p.tanggal) = MONTH(CURDATE())
        AND YEAR(p.tanggal) = YEAR(CURDATE())
        ORDER BY p.id_pesanan DESC
    ");
    $title = "Laporan Bulan Ini (" . date('F Y') . ")";
}

// --- FILTER TAHUN INI ---
if (isset($_POST['filter']) && $_POST['filter'] == "tahun") {
    $hasil = mysqli_query($conn, "
        SELECT p.*, pl.nama 
        FROM tb_pesanan p
        JOIN tb_pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
        WHERE YEAR(p.tanggal) = YEAR(CURDATE())
        ORDER BY p.id_pesanan DESC
    ");
    $title = "Laporan Tahun Ini (" . date('Y') . ")";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Laporan Pesanan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
        }
        .card-custom {
            background-color: rgba(245,230,204,0.95);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0,0,0,.2);
        }
        .table thead{
            background:#4A3728;
            color: #FFF8E7;
        }
        .btn-coffee{
            background-color:#8B5E3C;
            color:white;
        }
    </style>
</head>
<body>

<div class="container mt-4">

    <div class="card card-custom mb-4">
        <h2 class="mb-3">📊 Laporan Pesanan Omah Kopi</h2>
        <a href="admin_dasboard.php" class="btn btn-secondary mb-3">Kembali ke Dashboard</a>

        <!-- FILTER -->
        <form method="post" class="mb-4">

            <!-- Harian -->
            <div class="mb-3">
                <label><b>Laporan Harian:</b></label>
                <div class="input-group">
                    <input type="date" name="tanggal" class="form-control">
                    <button name="filter" value="harian" class="btn btn-coffee">Tampilkan</button>
                </div>
            </div>

            <!-- Bulan -->
            <div class="mb-3">
                <label><b>Laporan Bulan Ini:</b></label><br>
                <button name="filter" value="bulan" class="btn btn-coffee mt-1">Tampilkan Bulan Ini</button>
            </div>

            <!-- Tahun -->
            <div class="mb-3">
                <label><b>Laporan Tahun Ini:</b></label><br>
                <button name="filter" value="tahun" class="btn btn-coffee mt-1">Tampilkan Tahun Ini</button>
            </div>

        </form>
    </div>


    <!-- HASIL LAPORAN -->
    <?php if ($hasil !== null): ?>
    <div class="card card-custom">
        <h4><?php echo $title; ?></h4>

        <button onclick="window.print()" class="btn btn-primary mb-3">🖨 Cetak Laporan</button>

        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID Pesanan</th>
                    <th>Nama Pelanggan</th>
                    <th>Total</th>
                    <th>Tanggal</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $total_pendapatan = 0;
                while ($r = mysqli_fetch_assoc($hasil)) { 
                    $total_pendapatan += $r['total_harga'];
                ?>
                <tr>
                    <td><?php echo $r['id_pesanan']; ?></td>
                    <td><?php echo $r['nama']; ?></td>
                    <td>Rp <?php echo number_format($r['total_harga'], 0, ',', '.'); ?></td>
                    <td><?php echo $r['tanggal']; ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <h5 class="mt-3">Total Pendapatan: 
            <b>Rp <?php echo number_format($total_pendapatan, 0, ',', '.'); ?></b>
        </h5>
    </div>
    <?php endif; ?>

</div>

</body>
</html>
