<?php
session_start();
include 'config.php';

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_input = $_POST['email'];   // bisa email (pelanggan) atau username (admin)
    $password   = $_POST['password'];
    $role       = $_POST['role'];

    if ($role == 'pelanggan') {
        // Login pelanggan pakai email
        $sql    = "SELECT * FROM tb_pelanggan WHERE email = '$user_input'";
        $result = mysqli_query($conn, $sql);

        if ($row = mysqli_fetch_assoc($result)) {
            if (password_verify($password, $row['password'])) {
                $_SESSION['id_pelanggan'] = $row['id_pelanggan'];
                $_SESSION['nama']         = $row['nama'];
                header("Location: reservation.php");
                exit;
            } else {
                $error = "Password salah.";
            }
        } else {
            $error = "Email tidak ditemukan.";
        }
    } else {
        // Login admin/staff pakai username (disimpan di tb_admin)
        $sql    = "SELECT * FROM tb_admin WHERE username = '$user_input' AND role = '$role'";
        $result = mysqli_query($conn, $sql);

        if ($row = mysqli_fetch_assoc($result)) {
            // Di sini diasumsikan password admin disimpan PLAIN TEXT di database
            // Kalau di-hash, ganti dengan password_verify
            if ($row['password'] == $password) {
                $_SESSION['id_admin'] = $row['id_admin'];
                $_SESSION['username'] = $row['username'];
                $_SESSION['role']     = $row['role'];
                header("Location: admin_dasboard.php");
                exit;
            } else {
                $error = "Password salah.";
            }
        } else {
            $error = "Username/role tidak ditemukan.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .login-container {
            background-color: rgba(245, 230, 204, 0.9);
            padding: 20px;
            border-radius: 10px;
            max-width: 450px;
            margin: 50px auto;
        }
        .btn-login {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Login</h2>

        <?php if ($error != ''): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="mb-3">
                <label for="email" class="form-label">Email (pelanggan) / Username (admin)</label>
                <input type="text" class="form-control" id="email" name="email" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Kata Sandi</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <div class="mb-3">
                <label for="role" class="form-label">Peran</label>
                <select class="form-control" id="role" name="role">
                    <option value="pelanggan">Pelanggan</option>
                    <option value="admin">Admin</option>
                    <option value="staff">Staf</option>
                </select>
            </div>
            <button type="submit" class="btn btn-login">Login</button>
            <a href="register.php" class="btn btn-link">Belum punya akun? Daftar</a>
        </form>
    </div>
</body>
</html>
