<?php
session_start();
include 'config.php';

// Cek login pelanggan
if (!isset($_SESSION['id_pelanggan'])) {
    header("Location: login.php");
    exit;
}

$id_pelanggan = $_SESSION['id_pelanggan'];

// Ambil reservasi terakhir pelanggan ini
$q_res = mysqli_query($conn, "SELECT * FROM tb_daftar_reservasi 
                              WHERE id_pelanggan = '$id_pelanggan' 
                              ORDER BY id_reservasi DESC LIMIT 1");
$reservasi = mysqli_fetch_assoc($q_res);

if (!$reservasi) {
    // Kalau belum ada reservasi, paksa balik
    header("Location: reservation.php");
    exit;
}

$id_reservasi = $reservasi['id_reservasi'];

// Daftar menu (sementara hardcode, bisa nanti ambil dari tb_menu)
$menu_items = [];
$query_menu = mysqli_query($conn, "SELECT * FROM tb_daftar_menu ORDER BY kategori, nama_menu ASC");
while ($m = mysqli_fetch_assoc($query_menu)) {
    $menu_items[$m['id_menu']] = [
        "nama"  => $m['nama_menu'],
        "harga" => (int)$m['harga']   // decimal → integer untuk perhitungan
    ];
}

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $pesanan = [];
    $total_harga = 0;

    if (isset($_POST['qty']) && is_array($_POST['qty'])) {
        foreach ($_POST['qty'] as $id_menu => $qty) {
            $qty = (int)$qty;
            if ($qty > 0 && isset($menu_items[$id_menu])) {
                $item = $menu_items[$id_menu];
                $subtotal = $qty * $item['harga'];

                $pesanan[] = [
                    "nama"     => $item['nama'],
                    "qty"      => $qty,
                    "harga"    => $item['harga'],
                    "subtotal" => $subtotal
                ];
                $total_harga += $subtotal;
            }
        }
    }

    if (empty($pesanan)) {
        $error = "Silakan pilih minimal satu menu.";
    } else {
        // 1) Simpan ke tb_pesanan
        $now = date('Y-m-d H:i:s');
        $sql_pesanan = "INSERT INTO tb_pesanan (id_pelanggan, id_reservasi, tanggal, total_harga)
                        VALUES ('$id_pelanggan', '$id_reservasi', '$now', '$total_harga')";
        if (mysqli_query($conn, $sql_pesanan)) {
            $id_pesanan = mysqli_insert_id($conn);

            // 2) Simpan detail ke tb_pesanan_detail
            foreach ($pesanan as $p) {
                $nama_menu = mysqli_real_escape_string($conn, $p['nama']);
                $qty       = $p['qty'];
                $harga     = $p['harga'];
                $subtotal  = $p['subtotal'];

                $sql_detail = "INSERT INTO tb_pesanan_detail (id_pesanan, nama_menu, qty, harga, subtotal)
                               VALUES ('$id_pesanan', '$nama_menu', '$qty', '$harga', '$subtotal')";
                mysqli_query($conn, $sql_detail);
            }

            // 3) Simpan transaksi (status awal: belum bayar)
            $sql_trx = "INSERT INTO tb_transaksi (id_pesanan, tanggal, total, status)
                        VALUES ('$id_pesanan', '$now', '$total_harga', 'belum bayar')";
            mysqli_query($conn, $sql_trx);

            // 4) Arahkan ke halaman struk
            header("Location: struk.php?id_pesanan=" . $id_pesanan);
            exit;
        } else {
            $error = "Gagal menyimpan pesanan: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Menu - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .menu-container {
            background-color: rgba(245, 230, 204, 0.9);
            padding: 20px;
            border-radius: 10px;
            max-width: 900px;
            margin: 30px auto;
        }
        .table thead {
            background-color: #4A3728;
            color: #FFF8E7;
        }
        .btn-pesan {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="menu-container">
        <h2>Menu Omah Kopi</h2>
        <p>Terima kasih sudah melakukan reservasi (Meja: <?php echo $reservasi['nomor_meja']; ?>, Tanggal: <?php echo $reservasi['tanggal_reservasi']; ?>).</p>
        <p>Silakan pilih menu yang ingin dipesan:</p>

        <?php if ($error != ''): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="post">
            <table class="table table-bordered align-middle">
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th>Nama Menu</th>
                        <th style="width: 20%;">Harga</th>
                        <th style="width: 20%;">Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; foreach ($menu_items as $id => $item): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><?php echo htmlspecialchars($item['nama']); ?></td>
                            <td>Rp <?php echo number_format($item['harga'], 0, ',', '.'); ?></td>
                            <td>
                                <input type="number" 
                                       name="qty[<?php echo $id; ?>]" 
                                       class="form-control" 
                                       min="0" 
                                       value="0">
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <button type="submit" class="btn btn-pesan">Konfirmasi Pesanan</button>
            <a href="index.php" class="btn btn-secondary">Kembali ke Beranda</a>
        </form>
    </div>
</body>
</html>
