<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_admin'])) {
    header("Location: login.php");
    exit;
}

// PAKAI TABEL: tb_daftar_menu (bukan tb_menu)

// pesan notifikasi
$pesan = "";

// TAMBAH / UPDATE MENU
if (isset($_POST['save'])) {
    $id_menu = isset($_POST['id_menu']) && $_POST['id_menu'] !== '' ? (int)$_POST['id_menu'] : 0;
    $nama    = $_POST['nama_menu'];
    $harga   = (float)$_POST['harga'];
    $kategori = $_POST['kategori'];
    $gambar   = $_POST['gambar']; // sementara pakai teks nama file / url

    if ($id_menu > 0) {
        // mode EDIT
        $sql = "UPDATE tb_daftar_menu 
                SET nama_menu='$nama', harga='$harga', kategori='$kategori', gambar='$gambar'
                WHERE id_menu='$id_menu'";
        mysqli_query($conn, $sql);
        $pesan = "Menu berhasil diupdate!";
    } else {
        // mode TAMBAH
        $sql = "INSERT INTO tb_daftar_menu (nama_menu, harga, kategori, gambar)
                VALUES ('$nama', '$harga', '$kategori', '$gambar')";
        mysqli_query($conn, $sql);
        $pesan = "Menu baru berhasil ditambahkan!";
    }
}

// HAPUS MENU
if (isset($_GET['hapus'])) {
    $id = (int) $_GET['hapus'];
    mysqli_query($conn, "DELETE FROM tb_daftar_menu WHERE id_menu = '$id'");
    $pesan = "Menu berhasil dihapus!";
}

// DATA MENU
$data_menu = mysqli_query($conn, "SELECT * FROM tb_daftar_menu ORDER BY kategori, nama_menu ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Kelola Menu - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{
            background: url('wooden_texture.jpg') repeat;
        }
        .card{
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.1);
        }
        .btn-coffee{
            background-color:#8B5E3C;
            color:#FFF8E7;
        }
        .btn-coffee:hover{
            background-color:#6b4529;
            color:#FFF8E7;
        }
        .table thead{
            background-color:#4A3728;
            color:#FFF8E7;
        }
    </style>
</head>
<body>

<div class="container mt-4 mb-5">
    <h2>Kelola Menu Omah Kopi</h2>
    <a href="admin_dasboard.php" class="btn btn-secondary mb-3">Kembali ke Dashboard</a>

    <?php if ($pesan != "") : ?>
        <div class="alert alert-success"><?php echo $pesan; ?></div>
    <?php endif; ?>

    <!-- FORM TAMBAH / EDIT (modal edit pakai JS) -->
    <div class="card mb-4">
        <div class="card-header">
            Tambah Menu Baru
        </div>
        <div class="card-body">
            <form method="post">
                <input type="hidden" name="id_menu" value=""> <!-- kosong = tambah -->

                <div class="row">
                    <div class="col-md-4 mb-2">
                        <label>Nama Menu</label>
                        <input 
                            type="text" 
                            name="nama_menu" 
                            class="form-control" 
                            placeholder="Contoh: Es Kopi Susu"
                            required>
                    </div>
                    <div class="col-md-3 mb-2">
                        <label>Harga (Rp)</label>
                        <input 
                            type="number" 
                            step="100"
                            name="harga" 
                            class="form-control" 
                            placeholder="Contoh: 20000"
                            required>
                    </div>
                    <div class="col-md-3 mb-2">
                        <label>Kategori</label>
                        <select name="kategori" class="form-control" required>
                            <option value="kopi">Kopi</option>
                            <option value="makanan">Makanan</option>
                            <option value="minuman">Minuman</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <label>Gambar</label>
                        <input 
                            type="text" 
                            name="gambar" 
                            class="form-control" 
                            placeholder="nama_file.jpg">
                    </div>
                </div>
                <button name="save" class="btn btn-coffee mt-2">
                    Tambah Menu
                </button>
            </form>
        </div>
    </div>

    <!-- TABEL DAFTAR MENU -->
    <div class="card">
        <div class="card-header">
            Daftar Menu
        </div>
        <div class="card-body">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama Menu</th>
                        <th>Kategori</th>
                        <th>Harga</th>
                        <th>Gambar</th>
                        <th style="width: 180px;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($data_menu) > 0): ?>
                        <?php while ($m = mysqli_fetch_assoc($data_menu)) { ?>
                        <tr>
                            <td><?php echo $m['id_menu']; ?></td>
                            <td><?php echo htmlspecialchars($m['nama_menu']); ?></td>
                            <td><span class="badge bg-dark"><?php echo $m['kategori']; ?></span></td>
                            <td>Rp <?php echo number_format($m['harga'], 0, ',', '.'); ?></td>
                            <td><?php echo $m['gambar']; ?></td>
                            <td>
                                <!-- Tombol EDIT: isi modal -->
                                <button 
                                    type="button" 
                                    class="btn btn-warning btn-sm btn-edit"
                                    data-id="<?php echo $m['id_menu']; ?>"
                                    data-nama="<?php echo htmlspecialchars($m['nama_menu'], ENT_QUOTES); ?>"
                                    data-harga="<?php echo $m['harga']; ?>"
                                    data-kategori="<?php echo $m['kategori']; ?>"
                                    data-gambar="<?php echo htmlspecialchars($m['gambar'], ENT_QUOTES); ?>"
                                    data-bs-toggle="modal" 
                                    data-bs-target="#editModal">
                                    Edit
                                </button>

                                <a href="menu_admin.php?hapus=<?php echo $m['id_menu']; ?>" 
                                   class="btn btn-danger btn-sm"
                                   onclick="return confirm('Yakin hapus menu ini?');">
                                    Hapus
                                </a>
                            </td>
                        </tr>
                        <?php } ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">Belum ada menu.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- MODAL EDIT -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h5 class="modal-title">Edit Menu</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="id_menu" id="edit-id-menu">

            <div class="mb-3">
                <label class="form-label">Nama Menu</label>
                <input type="text" class="form-control" name="nama_menu" id="edit-nama-menu" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Harga (Rp)</label>
                <input type="number" class="form-control" name="harga" id="edit-harga" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Kategori</label>
                <select class="form-control" name="kategori" id="edit-kategori" required>
                    <option value="kopi">Kopi</option>
                    <option value="makanan">Makanan</option>
                    <option value="minuman">Minuman</option>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label">Gambar</label>
                <input type="text" class="form-control" name="gambar" id="edit-gambar">
            </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" name="save" class="btn btn-coffee">Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Isi modal edit dengan data dari tombol
document.querySelectorAll('.btn-edit').forEach(function(btn) {
    btn.addEventListener('click', function() {
        document.getElementById('edit-id-menu').value   = this.dataset.id;
        document.getElementById('edit-nama-menu').value = this.dataset.nama;
        document.getElementById('edit-harga').value     = this.dataset.harga;
        document.getElementById('edit-gambar').value    = this.dataset.gambar;

        // set kategori
        var kat = this.dataset.kategori;
        var selectKat = document.getElementById('edit-kategori');
        for (var i=0; i<selectKat.options.length; i++) {
            if (selectKat.options[i].value === kat) {
                selectKat.selectedIndex = i;
                break;
            }
        }
    });
});
</script>

</body>
</html>
