<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_admin'])) {
    header("Location: login.php");
    exit;
}

$q = mysqli_query($conn, "
    SELECT p.*, pl.nama, r.nomor_meja, r.tanggal_reservasi 
    FROM tb_pesanan p
    JOIN tb_pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
    JOIN tb_daftar_reservasi r ON p.id_reservasi = r.id_reservasi
    ORDER BY p.id_pesanan DESC
");

// simpan ke array dulu supaya bisa hitung total & jumlah
$orders = [];
$total_pesanan = 0;
$total_pendapatan = 0;

while ($row = mysqli_fetch_assoc($q)) {
    $orders[] = $row;
    $total_pesanan++;
    $total_pendapatan += $row['total_harga'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Pesanan Masuk - Admin Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .page-wrapper{
            max-width: 1100px;
            margin: 30px auto 40px;
        }
        .card-coffee{
            background-color: rgba(245,230,204,0.96);
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0,0,0,.15);
            border: none;
        }
        .card-header-coffee{
            background: linear-gradient(135deg,#4A3728,#8B5E3C);
            color: #FFF8E7;
            border-radius: 16px 16px 0 0 !important;
            padding: 18px 22px;
        }
        .table thead{
            background-color:#4A3728;
            color:#FFF8E7;
        }
        .badge-pill{
            border-radius: 999px;
        }
        .btn-coffee{
            background-color:#8B5E3C;
            color:#FFF8E7;
        }
        .btn-coffee:hover{
            background-color:#6b4529;
            color:#FFF8E7;
        }
        .search-box{
            max-width: 320px;
        }
        @media print{
            a, button, .search-box, .btn, .back-btn, .summary-row button{
                display:none !important;
            }
            body{
                background:none;
            }
            .page-wrapper{
                margin:0;
                max-width:100%;
            }
            .card-coffee{
                box-shadow:none;
            }
        }
    </style>
</head>
<body>

<div class="page-wrapper">
    <div class="card card-coffee">
        <div class="card-header card-header-coffee d-flex justify-content-between align-items-center flex-wrap gap-2">
            <div>
                <h4 class="mb-0">Daftar Pesanan Pelanggan</h4>
                <small>Ringkasan transaksi pesanan berdasarkan reservasi meja</small>
            </div>
            <div class="d-flex align-items-center gap-2">
                <a href="admin_dasboard.php" class="btn btn-sm btn-light back-btn">Kembali ke Dashboard</a>
                <button class="btn btn-sm btn-outline-light" onclick="window.print()">🖨 Cetak</button>
            </div>
        </div>

        <div class="card-body">
            <!-- Ringkasan kecil di atas -->
            <div class="row mb-3 summary-row">
                <div class="col-md-4 mb-2">
                    <div class="p-3 border rounded-3 bg-white h-100">
                        <div class="small text-muted">Total Pesanan</div>
                        <div class="h5 mb-0"><?php echo $total_pesanan; ?> pesanan</div>
                    </div>
                </div>
                <div class="col-md-4 mb-2">
                    <div class="p-3 border rounded-3 bg-white h-100">
                        <div class="small text-muted">Total Pendapatan</div>
                        <div class="h5 mb-0">Rp <?php echo number_format($total_pendapatan, 0, ',', '.'); ?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-2 d-flex justify-content-md-end align-items-center">
                    <div class="input-group search-box">
                        <span class="input-group-text">🔍</span>
                        <input type="text" id="searchInput" class="form-control" placeholder="Cari nama / meja / tanggal...">
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped align-middle" id="ordersTable">
                    <thead>
                        <tr>
                            <th style="width:100px;">ID Pesanan</th>
                            <th>Nama Pelanggan</th>
                            <th style="width:80px;">Meja</th>
                            <th style="width:180px;">Tanggal Reservasi</th>
                            <th style="width:160px;">Total Harga</th>
                            <th style="width:120px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($orders) > 0): ?>
                            <?php foreach ($orders as $p): ?>
                                <tr>
                                    <td>#<?php echo $p['id_pesanan']; ?></td>
                                    <td><?php echo htmlspecialchars($p['nama']); ?></td>
                                    <td>
                                        <span class="badge bg-dark badge-pill">
                                            <?php echo htmlspecialchars($p['nomor_meja']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo $p['tanggal_reservasi']; ?></td>
                                    <td>Rp <?php echo number_format($p['total_harga'], 0, ',', '.'); ?></td>
                                    <td>
                                        <a href="struk.php?id_pesanan=<?php echo $p['id_pesanan']; ?>" 
                                           class="btn btn-coffee btn-sm">
                                            Detail
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    Belum ada pesanan yang tercatat.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>

<script>
// Filter baris tabel berdasarkan input pencarian
document.getElementById('searchInput').addEventListener('keyup', function() {
    var filter = this.value.toLowerCase();
    var rows = document.querySelectorAll('#ordersTable tbody tr');

    rows.forEach(function(row) {
        var text = row.innerText.toLowerCase();
        row.style.display = text.indexOf(filter) > -1 ? '' : 'none';
    });
});
</script>

</body>
</html>
