<?php
include 'config.php';

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nama    = $_POST['nama'];
    $alamat  = $_POST['alamat'];
    $no_hp   = $_POST['no_hp'];
    $email   = $_POST['email'];
    $password_plain = $_POST['password'];
    $role = $_POST['role']; // admin / pelanggan / staff

    $password = password_hash($password_plain, PASSWORD_DEFAULT);

    // Jika role = pelanggan → simpan ke tabel tb_pelanggan
    if ($role == "pelanggan") {

        $cek = mysqli_query($conn, "SELECT id_pelanggan FROM tb_pelanggan WHERE email = '$email'");
        if (mysqli_num_rows($cek) > 0) {
            $error = "Email sudah terdaftar untuk pelanggan!";
        } else {
            $sql = "INSERT INTO tb_pelanggan (nama, alamat, no_hp, email, password)
                    VALUES ('$nama', '$alamat', '$no_hp', '$email', '$password')";
            if (mysqli_query($conn, $sql)) {
                header("Location: login.php");
                exit;
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }

    } else {
        // role admin/staff → simpan ke tb_admin (username = email)
        $cek = mysqli_query($conn, "SELECT id_admin FROM tb_admin WHERE username = '$email'");
        if (mysqli_num_rows($cek) > 0) {
            $error = "Email (username) sudah dipakai admin/staff!";
        } else {
            $sql = "INSERT INTO tb_admin (username, password, role)
                    VALUES ('$email', '$password', '$role')";
            if (mysqli_query($conn, $sql)) {
                header("Location: login.php");
                exit;
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .register-container {
            background-color: rgba(245, 230, 204, 0.9);
            padding: 20px;
            border-radius: 10px;
            max-width: 500px;
            margin: 50px auto;
        }
        .btn-register {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <h2>Daftar Akun</h2>

        <?php if ($error != ''): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="post">

            <div class="mb-3">
                <label class="form-label">Daftar Sebagai</label>
                <select class="form-control" name="role" required>
                    <option value="pelanggan">Pelanggan</option>
                    <option value="admin">Admin</option>
                    <option value="staff">Staff</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="nama" class="form-label">Nama</label>
                <input type="text" class="form-control" id="nama" name="nama" required>
            </div>

            <div class="mb-3">
                <label for="alamat" class="form-label">Alamat</label>
                <textarea class="form-control" id="alamat" name="alamat"></textarea>
            </div>

            <div class="mb-3">
                <label for="no_hp" class="form-label">Nomor Telepon</label>
                <input type="text" class="form-control" id="no_hp" name="no_hp" required>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">Email (dipakai untuk login)</label>
                <input type="email" class="form-control" id="email" name="email" required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Kata Sandi</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>

            <button type="submit" class="btn btn-register">Daftar</button>
            <a href="login.php" class="btn btn-link">Sudah punya akun? Login</a>
        </form>
    </div>
</body>
</html>
