<?php
session_start();
include 'config.php';

// Hanya admin yang boleh akses
if (!isset($_SESSION['id_admin']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password_plain = $_POST['password'];
    $role = $_POST['role']; // admin atau staff

    // Cek username sudah dipakai atau belum
    $check = mysqli_query($conn, "SELECT id_admin FROM tb_admin WHERE username = '$username'");
    if (mysqli_num_rows($check) > 0) {
        $error = "Username sudah digunakan, silakan pilih username lain.";
    } else {
        // Simpan password (hashed agar aman)
        $password = password_hash($password_plain, PASSWORD_DEFAULT);

        $sql = "INSERT INTO tb_admin (username, password, role)
                VALUES ('$username', '$password', '$role')";

        if (mysqli_query($conn, $sql)) {
            $success = "Admin baru berhasil ditambahkan.";
        } else {
            $error = "Error: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Admin Baru</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
        }
        .admin-form {
            background-color: rgba(245,230,204,0.95);
            padding: 20px;
            max-width: 500px;
            margin: 40px auto;
            border-radius: 10px;
        }
        .btn-add {
            background-color: #8B5E3C;
            color: white;
        }
    </style>
</head>
<body>

<div class="admin-form">
    <h3>Tambah Admin / Staff Baru</h3>

    <?php if ($error != ''): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>

    <?php if ($success != ''): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label class="form-label">Username Admin</label>
            <input type="text" class="form-control" name="username" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Password Admin</label>
            <input type="password" class="form-control" name="password" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Role</label>
            <select class="form-control" name="role">
                <option value="admin">Admin</option>
                <option value="staff">Staff</option>
            </select>
        </div>

        <button type="submit" class="btn btn-add">Tambah Admin</button>
        <a href="admin_dasboard.php" class="btn btn-secondary">Kembali</a>
    </form>
</div>

</body>
</html>
