<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_pelanggan'])) {
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id_pelanggan     = $_SESSION['id_pelanggan'];
    $tanggal_reservasi = $_POST['tanggal_reservasi'];
    $nomor_meja        = $_POST['nomor_meja'];

    $sql = "INSERT INTO tb_daftar_reservasi (id_pelanggan, tanggal_reservasi, nomor_meja, status)
            VALUES ('$id_pelanggan', '$tanggal_reservasi', '$nomor_meja', 'pending')";
    if (mysqli_query($conn, $sql)) {
        $success = "Reservasi berhasil dibuat. Silakan lihat menu.";
        header("Location: menu.php");
        exit;
    } else {
        $error = "Error: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservasi - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('wooden_texture.jpg') repeat;
            color: #3C2F2F;
        }
        .reservation-container {
            background-color: rgba(245, 230, 204, 0.9);
            padding: 20px;
            border-radius: 10px;
            max-width: 500px;
            margin: 50px auto;
        }
        .btn-reserve {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="reservation-container">
        <h2>Buat Reservasi</h2>

        <?php if ($error != ''): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if ($success != ''): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="mb-3">
                <label for="tanggal_reservasi" class="form-label">Tanggal Reservasi</label>
                <input type="date" class="form-control" id="tanggal_reservasi" name="tanggal_reservasi" required>
            </div>
            <div class="mb-3">
                <label for="nomor_meja" class="form-label">Nomor Meja</label>
                <select class="form-control" id="nomor_meja" name="nomor_meja" required>
                    <option value="">-- Pilih Meja --</option>
                    <option value="1">Meja 1</option>
                    <option value="2">Meja 2</option>
                    <option value="3">Meja 3</option>
                    <option value="VIP1">Meja VIP 1</option>
                </select>
            </div>
            <button type="submit" class="btn btn-reserve">Reservasi</button>
            <a href="menu.php" class="btn btn-link">Lihat Menu</a>
        </form>
    </div>
</body>
</html>
