<?php
session_start();
include 'config.php';

if (!isset($_SESSION['id_pelanggan'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id_pesanan'])) {
    header("Location: menu.php");
    exit;
}

$id_pesanan = (int)$_GET['id_pesanan'];

// Ambil data pesanan + pelanggan + reservasi
$sql = "SELECT p.*, pl.nama, pl.no_hp, r.nomor_meja, r.tanggal_reservasi
        FROM tb_pesanan p
        JOIN tb_pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
        JOIN tb_daftar_reservasi r ON p.id_reservasi = r.id_reservasi
        WHERE p.id_pesanan = '$id_pesanan'";
$q_pesanan = mysqli_query($conn, $sql);
$pesanan = mysqli_fetch_assoc($q_pesanan);

if (!$pesanan) {
    header("Location: menu.php");
    exit;
}

$q_detail = mysqli_query($conn, "SELECT * FROM tb_pesanan_detail WHERE id_pesanan = '$id_pesanan'");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Struk Pesanan - Omah Kopi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f2e2c4;
        }
        .struk-container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            max-width: 600px;
            margin: 30px auto;
            border: 1px solid #d1b79b;
        }
        .judul {
            text-align: center;
            margin-bottom: 15px;
        }
        .total {
            font-size: 18px;
            font-weight: bold;
            text-align: right;
        }
        .btn-print {
            background-color: #8B5E3C;
            color: #FFF8E7;
        }
    </style>
</head>
<body>
    <div class="struk-container">
        <div class="judul">
            <h3>Omah Kopi</h3>
            <p>Struk Reservasi & Pemesanan Menu</p>
        </div>

        <p><strong>Nama Pelanggan:</strong> <?php echo htmlspecialchars($pesanan['nama']); ?></p>
        <p><strong>No HP:</strong> <?php echo htmlspecialchars($pesanan['no_hp']); ?></p>
        <p><strong>Meja:</strong> <?php echo htmlspecialchars($pesanan['nomor_meja']); ?></p>
        <p><strong>Tanggal Reservasi:</strong> <?php echo htmlspecialchars($pesanan['tanggal_reservasi']); ?></p>
        <p><strong>Tanggal Transaksi:</strong> <?php echo htmlspecialchars($pesanan['tanggal']); ?></p>

        <hr>

        <table class="table table-sm">
            <thead>
                <tr>
                    <th>Menu</th>
                    <th>Qty</th>
                    <th>Harga</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($d = mysqli_fetch_assoc($q_detail)) { ?>
                    <tr>
                        <td><?php echo htmlspecialchars($d['nama_menu']); ?></td>
                        <td><?php echo $d['qty']; ?></td>
                        <td>Rp <?php echo number_format($d['harga'], 0, ',', '.'); ?></td>
                        <td>Rp <?php echo number_format($d['subtotal'], 0, ',', '.'); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>

        <p class="total">Total: Rp <?php echo number_format($pesanan['total_harga'], 0, ',', '.'); ?></p>

        <p>Terima kasih telah berkunjung ke Omah Kopi.</p>

        <button onclick="window.print()" class="btn btn-print btn-sm">Cetak Struk</button>
        <a href="index.php" class="btn btn-secondary btn-sm">Kembali ke Beranda</a>
    </div>
</body>
</html>
